#pragma once

#ifndef _AraTrustFinger_H_
#define _AraTrustFinger_H_

#include "Windef.h"
#include "stdafx.h"
#include "crc.h"

#define DEVICE_MODEL_A400		400	//A400 device


//return code
//General code
#define  GEN_SUCCEDED				   0    //OK 
#define  GEN_PARAM_NULL				   10    //ڴΪ

#define  GEN_PAR_ERR				-900	//󣬸Ĳд
#define  GEN_MEM_ERR				-901	//ڴʧܣûз䵽㹻ڴ档
#define  GEN_FUC_FAIL				-902	//δʵָ֣֧ù
#define  GEN_ILLEGAL_ERR			-903	//ǷĴš
#define  GEN_FIRMWARE_ERR			-904	//FIRMWARE Error
#define  GEN_INIT_FAIL              -905    //Init fail
#define  GEN_OTHER_ERR				-910	//

//Device
#define  DEV_NOT_FIND				-100	//豸ڡʼʱ򣬼⵽豸ڡ
#define  DEV_NOT_AUTHORIZE          -101    //豸ûȨ
#define  DEV_NOT_INIT				-102	//δʼ
#define  DEV_NOT_OPEN				-103	//豸δ򿪡
#define  DEV_NOT_SUPPORT			-104	//Device not support

#define  DEV_LED_FAIL               -106    //Call Device LED fail
#define  DEV_BEGIN_FAIL				-110	//׼ɼһ֡ͼʧܣǰڻȡͼ
#define  DEV_NOT_CALL_BEGIN	        -111	//δ׼һ֡ͼ
#define  DEV_GET_IMA_FAIL			-112	//ȡͼʧ
#define  DEV_GET_IMA_TIMEOUT		-113	//ȡͼʱ
#define  DEV_OCCUPY_OTHER		    -114	//̻߳ռ
#define  SDK_INIT_DONE		        -115	//SDK inited done
#define  DEVICE_OPENED		        -117	//device inited done
#define  DEVICE_DESC_FAIL		    -118	//get device description fail
#define  DEV_COMMUNICATE_FAIL       -119    //豸ͨѶʧ
#define  DEV_COMMUNICATE_UNSUPPORT  -120    //豸ͨѶЭ鲻֧
#define  DEV_INSTRUCTION_ERROR      -121    //ָ
#define  DEV_ENCODE_FAIL            -122    //ʧ
#define  DEV_DECODE_FAIL            -123    //ʧ
#define  DEV_TOO_DRY                -124    //豸̫
#define  DEV_TOO_WET                -125    //豸̫ʪ
#define  DEV_LITTLE_FEATURE         -126    //̫
#define  DEV_LIVE_CAPTURING         -127    //ʵʱɼ
#define  DEV_LIVE_NOT_BEGIN         -128    //ʵʱɼδʼ
#define  DEV_LFD_FAIL               -129    //EnableLFD fail
#define  DEV_FAKE_FINGERPRINT       -130    //Fake Fingerprint
#define  DEV_UNKNOWN_FINGERPRINT    -131    //Unknown Fingerprint
#define  DEV_NO_FINGERPRINT         -132    //No Fingerprint
#define  DEV_LIVE_ENDLIVECAPTURE      11    //ʵʱɼ

//Arithmetic
#define   ALG_INIT_FAIL		        -200 	//ʼָ㷨ʧ
#define   ALG_NO_WSQ                -201    //ûWSQ㷨
#define   ALG_RAWTOWSQ_FAIL         -202    //ԭʼͼתWSQ
#define   ALG_NO_NFIQ               -203    //no NFIQ lib
#define   ALG_RAWTOISO_FAIL         -204    //RAW to ISO fail
#define   ALG_RAWTOANSI_FAIL        -205    //RAW to ANSI fail
#define   ALG_IMG_BUF_NO_DATA		-210	//ͼ񻺳ûЧָ
#define   ALG_IMG_QUALITY_LOW		-211	//ͼ̫
#define   ALG_INVALID_BMP_DATA		-212    //ЧBMP
#define   ALG_BIONE_NOT_INIT        -220	//㷨δʼ
#define   ALG_EXTRACT_FEATURE_FAIL  -221	//ȡָʧ
#define   ALG_GEN_TEMPLATE_FAIL     -222	//ָģʧ




typedef struct _ARAFP_DEVICEDESC
{
	char serialNumber[32]; /* Device serial number */
	char manufacturer[32]; /* manufacturer */
	char productName[64]; /* Device product name */
	char productModel[32]; /* Device product model */
	char fwVersion[32]; /* Device firmware version */
	char hwVersion[32]; /* Device revision */

	int imageWidth; /*Device capture max image width*/
	int imageHeight;/*Device capture max image height*/
	int Dpi; /*Device capture max image DPI*/
	unsigned short deviceId; /*Device id*/

	bool isUSBSupported; // device support USE connected type or not
	bool isUARTSupported; //device suppport UART or not
	bool isSPISupported; //device support SPI or not
	bool isLedSupported; //device support led or not
}ARAFP_DevDesc;


int __stdcall ARAFPSCAN_GlobalInit();

int __stdcall ARAFPSCAN_GlobalFree();

int __stdcall ARAFPSCAN_GetDeviceCount(int *nDeviceCount);

int __stdcall ARAFPSCAN_OpenDevice(HANDLE *nHandle,int nIndex);

int __stdcall ARAFPSCAN_CloseDevice(HANDLE *nHandle);

int __stdcall ARAFPSCAN_GetDeviceDescription(const int deviceIndex, ARAFP_DevDesc *pDeviceDesc);

int __stdcall ARAFPSCAN_GetImageInfo(HANDLE nHandle, int *pnWidth, int *pnHeight, int *pnDpi);

int __stdcall ARAFPSCAN_CaptureRawData(HANDLE nHandle, int nTimeout, unsigned char *pRawData);

int __stdcall ARAFPSCAN_CaptureBitmapData(HANDLE nHandle, int nTimeout, unsigned char *pBmpData);

int __stdcall ARAFPSCAN_CaptureISOData(HANDLE nHandle, int nTimeout, int FingerPos, int Imgcompressalg, unsigned char *ISOImgData, int *pLenOutput);

int __stdcall ARAFPSCAN_CaptureANSIData(HANDLE nHandle, int nTimeout, int FingerPos, int Imgcompressalg, unsigned char *ISOImgData, int *pLenOutput);

int __stdcall ARAFPSCAN_SetLedStatus(HANDLE nHandle, int nLedIndex, int pStatus);

int __stdcall ARAFPSCAN_GetLedStatus(HANDLE nHandle, int nLedIndex, int *pnStatus);
 
int __stdcall ARAFPSCAN_ExtractFeature(HANDLE nHandle, int cFingerPos, unsigned char * pFeatureData);

int __stdcall ARAFPSCAN_ExtractANSIFeature(HANDLE nHandle, int cFingerPos, unsigned char * pFeatureData);

int __stdcall ARAFPSCAN_ExtractISOFeature(HANDLE nHandle, int cFingerPos, unsigned char * pFeatureData);

int __stdcall ARAFPSCAN_GeneralizeTemplate(HANDLE nHandle,
	unsigned char * pFeatureData1,
	unsigned char * pFeatureData2,
	unsigned char * pFeatureData3,
	unsigned char * pTemplateData);

int __stdcall ARAFPSCAN_RawToBitmap(unsigned char* pRawData,
	unsigned char* pBmpData,
	int nWidth, int nHeight);

int __stdcall ARAFPSCAN_RawToWSQ(unsigned char* pRawData,
	int nWidth, int nHeight, int dpi, double bitrate, unsigned char* pWSQData, int* lengthWSQ);

int __stdcall ARAFPSCAN_BitmapToRaw(unsigned char* pBmpData,
	unsigned  char* pRawData,
	int pnWidth, int pnHeight);

int __stdcall ARAFPSCAN_GetErrorInfo(int nErrorNo, char pszErrorInfo[256]);

int __stdcall ARAFPSCAN_ImgQuality(int width, int height, BYTE *ipImage, BYTE *Quality);

int __stdcall ARAFPSCAN_GetNFIQScore(int width, int height, BYTE *ipImage, BYTE *Quality);

int __stdcall ARAFPSCAN_Verify(HANDLE nHandle, int Security_Level, unsigned char * pFeatureData, unsigned char * pTemplateData, int *sc,int *presult);

int __stdcall ARAFPSCAN_EnableLFD(HANDLE nHandle, bool pEnableLFD, int LFD_Level);

int __stdcall ARAFPSCAN_BeginLiveCapture(HANDLE nHandle);

int __stdcall ARAFPSCAN_LiveCaptureRawData(HANDLE nHandle, unsigned char *pRawData);

int __stdcall ARAFPSCAN_LiveCaptureBitmap(HANDLE nHandle, unsigned char *pBmpData);

int __stdcall ARAFPSCAN_EndLiveCapture(HANDLE nHandle);
#endif